/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.WriterBinaryBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.HDFSTool;

public class WriterBinaryBlockParallel
extends WriterBinaryBlock {
    public WriterBinaryBlockParallel(int replication) {
        super(replication);
    }

    @Override
    protected void writeBinaryBlockMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        int numPartFiles = (int)(OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, (long)blen, src.getNonZeros()) / InfrastructureAnalyzer.getHDFSBlockSize());
        numPartFiles = Math.max(numPartFiles, 1);
        int numThreads = OptimizerUtils.getParallelBinaryWriteParallelism();
        if ((numThreads = Math.min(numThreads, numPartFiles)) <= 1) {
            super.writeBinaryBlockMatrixToHDFS(path, job, fs, src, rlen, clen, blen);
            return;
        }
        HDFSTool.createDirIfNotExistOnHDFS(path, "777");
        try {
            ExecutorService pool = CommonThreadPool.get(numThreads);
            ArrayList<WriteFileTask> tasks = new ArrayList<WriteFileTask>();
            int blklen = (int)Math.ceil((double)rlen / (double)blen / (double)numThreads) * blen;
            int i = 0;
            while (i < numThreads & (long)(i * blklen) < rlen) {
                Path newPath = new Path(path, IOUtilFunctions.getPartFileName(i));
                tasks.add(new WriteFileTask(newPath, job, fs, src, i * blklen, Math.min((long)((i + 1) * blklen), rlen), blen));
                ++i;
            }
            List rt = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future future : rt) {
                future.get();
            }
            if (fs instanceof LocalFileSystem) {
                int i2 = 0;
                while (i2 < numThreads & (long)(i2 * blklen) < rlen) {
                    IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, new Path(path, IOUtilFunctions.getPartFileName(i2)));
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel write of binary block input.", e);
        }
    }

    private class WriteFileTask
    implements Callable<Object> {
        private Path _path = null;
        private JobConf _job = null;
        private FileSystem _fs = null;
        private MatrixBlock _src = null;
        private long _rl = -1L;
        private long _ru = -1L;
        private int _blen = -1;

        public WriteFileTask(Path path, JobConf job, FileSystem fs, MatrixBlock src, long rl, long ru, int blen) {
            this._path = path;
            this._fs = fs;
            this._job = job;
            this._src = src;
            this._rl = rl;
            this._ru = ru;
            this._blen = blen;
            this._blen = blen;
        }

        @Override
        public Object call() throws Exception {
            WriterBinaryBlockParallel.this.writeBinaryBlockMatrixToSequenceFile(this._path, this._job, this._fs, this._src, this._blen, (int)this._rl, (int)this._ru);
            return null;
        }
    }
}

